//Dustin Soodak



//behavior 047: recording data with variable rate & number of columns

#include "MiscHardware.h"
#ifndef sbi
#define sbi(sfr, bit) (_SFR_BYTE(sfr) |= _BV(bit))
#endif


int FastReadingLeft(void){
  uint8_t low, high;
#if defined(ADCSRB) && defined(MUX5)
	// the MUX5 bit of ADCSRB selects whether we're reading from channels
	// 0 to 7 (MUX5 low) or 8 to 15 (MUX5 high).
	ADCSRB = (ADCSRB & ~(1 << MUX5)) | (((pin >> 3) & 0x01) << MUX5);
#endif  
	// set the analog reference (high two bits of ADMUX) and select the
	// channel (low 4 bits).  this also sets ADLAR (left-adjust result)
	// to 0 (the default).
#if defined(ADMUX)
	ADMUX = (1 << 6) | (LightSense_Left & 0x07);//ADMUX = (analog_reference << 6) | (pin & 0x07);
#endif
	// without a delay, we seem to read from the wrong channel
	//delay(1);
#if defined(ADCSRA) && defined(ADCL)
	// start the conversion
	sbi(ADCSRA, ADSC);
	// ADSC is cleared when the conversion finishes
	while (bit_is_set(ADCSRA, ADSC));
	// we have to read ADCL first; doing so locks both ADCL
	// and ADCH until ADCH is read.  reading ADCL second would
	// cause the results of each conversion to be discarded,
	// as ADCL and ADCH would be locked when it completed.
	low  = ADCL;
	high = ADCH;
#else
	// we dont have an ADC, return 0
	low  = 0;
	high = 0;
#endif
	// combine the two bytes
	return (high << 8) | low;
}

int FastReadingRight(void){
  uint8_t low, high;
#if defined(ADCSRB) && defined(MUX5)
	ADCSRB = (ADCSRB & ~(1 << MUX5)) | (((pin >> 3) & 0x01) << MUX5);
#endif  

#if defined(ADMUX)
	ADMUX = (1 << 6) | (LightSense_Right & 0x07);//ADMUX = (analog_reference << 6) | (pin & 0x07);
#endif
#if defined(ADCSRA) && defined(ADCL)
	sbi(ADCSRA, ADSC);	// ADSC is cleared when the conversion finishes
	while (bit_is_set(ADCSRA, ADSC));
	low  = ADCL;
	high = ADCH;
#else
	low  = 0;
	high = 0;
#endif
	return (high << 8) | low;
}
int FastReadingRear(void){
  uint8_t low, high;
#if defined(ADCSRB) && defined(MUX5)
	ADCSRB = (ADCSRB & ~(1 << MUX5)) | (((pin >> 3) & 0x01) << MUX5);
#endif  

#if defined(ADMUX)
	ADMUX = (1 << 6) | (LightSense_Rear & 0x07);//ADMUX = (analog_reference << 6) | (pin & 0x07);
#endif
#if defined(ADCSRA) && defined(ADCL)
	sbi(ADCSRA, ADSC);	// ADSC is cleared when the conversion finishes
	while (bit_is_set(ADCSRA, ADSC));
	low  = ADCL;
	high = ADCH;
#else
	low  = 0;
	high = 0;
#endif
	return (high << 8) | low;
}

int delus=1;
#include "MiscHardware.h"
void setup(){
  HardwareBegin();
  SwitchButtonToPixels();
  //This section lets you know when the robot restarts:
  PlayChirp(1000, 50);
  SetPixelRGB(5,0,0,50);SetPixelRGB(6,0,0,50);RefreshPixels();
  delay(100);
  SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();
  PlayChirp(1000, 0);
  SwitchPixelsToButton();
  Serial.println("\r\nEnter us delay:");
  while(!Serial.available());
  delus=Serial.parseInt();
  Serial.print(delus);Serial.println(" us");
}
int i,j;
int32_t total;
#define LIGHTSENSORS 1 //number of light sensors read
#define READINGS 100
unsigned int data[READINGS][LIGHTSENSORS+1];
void loop(){
  while(!ButtonPressed());
  while(ButtonPressed()); 
  delay(500); 
  
  //ExploreExample(150,60,2000);
  //while(1);
  
  
  SwitchEdgeToAmbient();
  RestartTimer();
  for(i=0;i<READINGS;i++){  
    if(delus)
      delayMicroseconds(delus); 
    ////delayMicroseconds(100); 
    LeftAmbientLightLevel=ReadLeftLightSensor();
    //RightAmbientLightLevel=ReadRightLightSensor();
    //RearAmbientLightLevel=ReadRearLightSensor();
    data[i][1]=LeftAmbientLightLevel;
    //data[i][2]=RightAmbientLightLevel;
    //data[i][3]=RearAmbientLightLevel;
    //data[i][1]=FastReadingLeft();
    
  }
  total=GetTime();
  total*=10;
  for(i=0;i<READINGS;i++){
    data[i][0]=total*i/READINGS;
    for(j=0;j<LIGHTSENSORS+1;j++){
      Serial.print(data[i][j]);
      if(j==LIGHTSENSORS)
        Serial.print("\r\n");
      else
        Serial.print("\t");
    }
  }
  Serial.println();
  while(!ButtonPressed());
  while(ButtonPressed()); 
  //
  while(!ButtonPressed()){
    ReadSideSensors();  
    if(GetTime()>500){       
      Serial.print(" L: ");
      Serial.print(LeftLightLevel,DEC);
      Serial.print(" R: ");
      Serial.print(RightLightLevel,DEC);   
      Serial.print(" B: ");
      Serial.print(RearLightLevel,DEC);   
      Serial.print(" LAm: ");
      Serial.print(LeftAmbientLightLevel,DEC);
      Serial.print(" RAm: ");
      Serial.print(RightAmbientLightLevel,DEC);   
      Serial.print(" BAm: ");
      Serial.print(RearAmbientLightLevel,DEC);
      Serial.println();
      RestartTimer();
    }//end if(GetTime()>200)
  }//end while(!ButtonPressed())
  //
}//end loop()



/*

//print received IR data
#include "MiscHardware.h"
void setup(){
  HardwareBegin(); 
  RxIRRestart();
}
int i;
void loop(){
  if(IsIRDone()){
      RxIRStop();
      for(i=0;i<IRNumOfBytes;i++){
        Serial.println(((unsigned char)IRBytes[i]),HEX);
      }
      RxIRRestart();
  }
}

*/


